/*
  This file is part of TALER
  Copyright (C) 2020, 2023, 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_spa.c
 * @brief logic to load the single page app (/)
 * @author Christian Grothoff
 */
#include "platform.h"
#include <gnunet/gnunet_util_lib.h>
#include <taler/taler_util.h>
#include <taler/taler_mhd_lib.h>
#include "taler_merchant_util.h"
#include "taler-merchant-httpd_statics.h"
#include "taler-merchant-httpd_spa.h"
#include <gnunet/gnunet_mhd_compat.h>


/**
 * Resources of the Merchant SPA.
 */
static struct TALER_MHD_Spa *spa;


MHD_RESULT
TMH_return_spa (const struct TMH_RequestHandler *rh,
                struct MHD_Connection *connection,
                struct TMH_HandlerContext *hc)
{
  const char *infix = hc->infix;

  if ( (NULL == infix) ||
       (0 == strcmp (infix,
                     "")) )
    infix = "index.html";
  return TALER_MHD_spa_handler (spa,
                                connection,
                                infix);
}


enum GNUNET_GenericReturnValue
TMH_spa_init ()
{
  spa = TALER_MHD_spa_load (TALER_MERCHANT_project_data (),
                            "spa/");
  if (NULL == spa)
  {
    GNUNET_break (0);
    return GNUNET_SYSERR;
  }
  return GNUNET_OK;
}


/**
 * Nicely shut down.
 */
void __attribute__ ((destructor))
get_spa_fini (void);

/* Declaration to avoid compiler warning */
void __attribute__ ((destructor))
get_spa_fini ()
{
  if (NULL != spa)
  {
    TALER_MHD_spa_free (spa);
    spa = NULL;
  }
}
